/** @file   mediumwormalien.cpp
 * @brief   Implementation of MediumWormAlien - class.
 * @version $Revision: 1.3 $
 * @author  Tomi Lamminsaari
 */

#include "mediumwormalien.h"
#include "warglobals.h"
#include "animplayer.h"
#include "gameanims.h"
#include "settings.h"
#include "aicontroller.h"
#include "AnimId.h"
using namespace eng2d;

namespace WeWantWar {

///
/// Static members, constants and datatypes
/// =======================================




///
/// Constructors, destructor and operators
/// ======================================
/** Constructor
 */
MediumWormAlien::MediumWormAlien() :
  SmallWormAlien()
{
  ObjectID::Type oid = this->objectType();
  // Set the moving speed.
  m_spdVec.y( - Settings::floatObjProp(oid, "spd_walk:") );

  this->setCorrectAnimation( GameAnims::EWalk );
  this->boundingSphere( Settings::floatObjProp(oid, "bounding_sphere:") );
  this->setArmor( Settings::floatObjProp(oid, "armor:") );
  m_reloadingDelay = Settings::intObjProp(oid, "reload:" );
}



/** Destructor
 */
MediumWormAlien::~MediumWormAlien()
{
}




///
/// Public methods
/// ==============

/** The update method
 */
void MediumWormAlien::update()
{
  if ( this->state() == GameObject::STATE_DYING ) {
    if ( m_animation.paused() ) {
      // The alientype 2 fires some bullets when it dies
      this->state( GameObject::STATE_KILLED );
      this->setCorrectAnimation( GameAnims::EKilled );
    }
    return;
  } else {
    SmallWormAlien::update();
  }
}




///
/// Getter methods
/// ==============

/** Returns the type of this object
 */
ObjectID::Type MediumWormAlien::objectType() const
{
  return ObjectID::TYPE_MEDIUMWORMALIEN;
}




///
/// Private or Protected methods
/// ============================

/** Handles the shooting
 */
void MediumWormAlien::attack()
{
  AIController* pAIC = dynamic_cast< AIController* >( this->getController() );
  GameObject* pT = pAIC->getTarget();
  if ( pT == 0 ) {
    return;
  }
  
  Vec2D dirVec( pT->position() );
  dirVec -= this->position();
  dirVec.norm();
  dirVec *= 14;

  Bullet* bullet = BulletTable::createBullet( this, this->position(),
                                          Bullet::EAlienFireball );
  bullet->setVelocity( dirVec );
  bullet->iDamage  *= 2.5;
  WarGlobals::pBulletManager->spawnBullet( bullet );
  
  const Animation& lightAnim = GameAnims::findAnimation( AnimId::KSmallWormShootLight, 0 );
  if ( Settings::shootingLights == true ) {
    AnimPlayer::spawnLit( lightAnim, this->position(), 0 );
  }
}



/** Sets the correct animation
 */
void MediumWormAlien::setCorrectAnimation( int aAnimId )
{
  const Animation& anim = GameAnims::findAnimation( AnimId::KMediumWormAlien, aAnimId );
  this->setAnimation( anim, aAnimId);
}


} // end of namespace
